/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.internal.ProtocolLogger;
import com.aptana.js.debug.core.model.IJSConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.ILaunch;

public class JSConnectionInitializersRegistry {
    private static final String EXTENSION_POINT_ID = "jsConnectionInitializers";
    private static final String ELEMENT_TYPE = "connectionInitializer";
    private static final String CLASS_ATTR = "class";
    private static final String ID_ATTR = "id";
    private static final String PRIORITY_ATTR = "priority";
    private static final String MODE_ATTR = "mode";
    private Map<String, IConfigurationElement> jsConnections;
    private static JSConnectionInitializersRegistry instance;

    private JSConnectionInitializersRegistry() {
        this.load();
    }

    public static synchronized IJSConnection getConnection(String mode, Socket socket, ProtocolLogger logger, ILaunch launch) {
        if (instance == null) {
            instance = new JSConnectionInitializersRegistry();
        }
        return instance.createJSConnection(mode, socket, logger, launch);
    }

    public static synchronized IJSConnection getConnection(String mode, InetSocketAddress inetSocketAddress, ProtocolLogger logger, ILaunch launch) {
        if (instance == null) {
            instance = new JSConnectionInitializersRegistry();
        }
        return instance.createJSConnection(mode, inetSocketAddress, logger, launch);
    }

    private IJSConnection createJSConnection(String mode, Socket socket, ProtocolLogger logger, ILaunch launch) {
        IJSConnection ijsConnection = this.getConnection(mode);
        if (ijsConnection != null) {
            try {
                ijsConnection.initialize(socket, logger, launch);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)MessageFormat.format("Error initializing a {0} connection", mode), (Throwable)e);
            }
        }
        return ijsConnection;
    }

    private IJSConnection createJSConnection(String mode, InetSocketAddress inetSocketAddress, ProtocolLogger logger, ILaunch launch) {
        IJSConnection ijsConnection = this.getConnection(mode);
        if (ijsConnection != null) {
            try {
                ijsConnection.initialize(inetSocketAddress, logger, launch);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)MessageFormat.format("Error initializing a {0} connection", mode), (Throwable)e);
            }
        }
        return ijsConnection;
    }

    private IJSConnection getConnection(String mode) {
        final IConfigurationElement element = this.jsConnections.get(mode);
        if (element == null) {
            return null;
        }
        final IJSConnection[] connection = new IJSConnection[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                connection[0] = (IJSConnection)element.createExecutableExtension(JSConnectionInitializersRegistry.CLASS_ATTR);
            }

            public void handleException(Throwable exception) {
                if (exception instanceof CoreException) {
                    IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)MessageFormat.format("Error loading an IJSConnection - id={0}", element.getAttribute(JSConnectionInitializersRegistry.ID_ATTR)), (Throwable)exception);
                }
            }
        });
        return connection[0];
    }

    private void load() {
        if (this.jsConnections == null) {
            this.jsConnections = new HashMap<String, IConfigurationElement>();
            EclipseUtil.processConfigurationElements((String)"com.aptana.js.debug.core", (String)EXTENSION_POINT_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    String mode = element.getAttribute(JSConnectionInitializersRegistry.MODE_ATTR).trim();
                    int priority = JSConnectionInitializersRegistry.this.getPriority(element);
                    IConfigurationElement existingElement = (IConfigurationElement)JSConnectionInitializersRegistry.this.jsConnections.get(mode);
                    if (existingElement != null) {
                        if (priority > JSConnectionInitializersRegistry.this.getPriority(existingElement)) {
                            JSConnectionInitializersRegistry.this.jsConnections.put(mode, element);
                        }
                    } else {
                        JSConnectionInitializersRegistry.this.jsConnections.put(mode, element);
                    }
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{JSConnectionInitializersRegistry.ELEMENT_TYPE});
                }
            });
        }
    }

    private int getPriority(IConfigurationElement element) {
        String priorityStr = element.getAttribute(PRIORITY_ATTR);
        int priority = 0;
        try {
            priority = Integer.parseInt(priorityStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return priority;
    }
}

